/*
 * Decompiled with CFR 0.152.
 */
package pt.caf_pbs.schooldiskapi.model;

import java.io.Serializable;
import pt.caf_pbs.schooldiskapi.exceptions.InvalidDataException;
import pt.caf_pbs.schooldiskapi.model.Student;
import pt.caf_pbs.schooldiskapi.model.Subject;

public class Enroll
implements Serializable {
    private int grade;
    private Subject subject;
    private Student student;

    public Enroll(int grade, Subject subject, Student student) {
        this.setGrade(grade);
        this.setSubject(subject);
        this.setStudent(student);
    }

    private boolean isRefNotNull(Object ptr) {
        return ptr != null;
    }

    public int getGrade() {
        return this.grade;
    }

    public void setGrade(int grade) {
        if (grade < 10) {
            String msg = "Enroll: grade = " + grade;
            throw new InvalidDataException(msg);
        }
        this.grade = grade;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        if (!this.isRefNotNull((Object)subject)) {
            String msg = "Enroll: subject = NULL";
            throw new InvalidDataException(msg);
        }
        this.subject = subject;
    }

    public Student getStudent() {
        return this.student;
    }

    public void setStudent(Student student) {
        if (!this.isRefNotNull((Object)student)) {
            String msg = "Enroll: student = NULL";
            throw new InvalidDataException(msg);
        }
        this.student = student;
    }

    public boolean isEqualTo(Enroll obj) {
        return this.student.isEqualTo(obj.student) && this.subject.isEqualTo(obj.subject);
    }
}

